;
; This sample configuration file shows a rather complicated setup for
; echomail hubbing.  It takes into account the change in costs for
; calls based on a long distance calling plan.
;
;  First the "standard" TIMS.CTL system information
;
;****************************************************************************
NAME   Phil Becker
SYSTEM TBBS Sample - Aurora, Co
NODE   1:104/23
AKA    1:1003/103
NO-FORWARD
LOGFILE  d:\tbbs\tims.log
;
; Define file areas for TIMS traffic
;****************************************************************************
OUTBOUND d:\tbbs\wrk\run\outbound
ARCMAIL  d:\tbbs\wrk\run\outbound
MAIL     d:\tbbs\wrk\run\messages
FILES    d:\tbbs\wrk\run\infile  d:\tbbs\wrk\run\verif  d:\tbbs\wrk\run\badpw
PACKET   d:\tbbs\wrk\run\infile
;
;  DEfine file areas for pickup (except during net mail hour)
;****************************************************************************
RESTRICT TIME 02:00 01:00      ;From midnite to 1am, and from 2am to midnite
   PICKUP   d:\tbbs\ibm
   PICKUP   d:\tbbs\macstuff
ENDRESTRICT
;
;   Define commands for TIMS internal echomail tossing...
;****************************************************************************
MsgArea COMM        "Comm Echo"
MsgArea FIDOSYSP    "Local Sysop"
MsgArea TBBS        "MS-DOS TBBS"
MsgArea TECH        "Tech Echo"
;
;  Toss echomail and net mail every 15 minutes.
;  Scan NET MAIL every 10 minutes (Echomail must be scanned off-line)
;  Use any available ghost line to do toss/scan (line=254)
;
DOTBBS 10 254 SCAN
DOTBBS 15 254 TOSS /H
;****************************************************************************
;
; Now set up the dialing plan....
;
; Let us assume you have Reach Out America which costs $0.11 per minute
; for any minutes used from 10pm-8am every day, as well as all day Saturday
; and from 8am-5pm on Sunday.  From 8am-5pm during the week it costs too
; much to bother dialing, and all other times it costs $0.11 or less for some
; nodes (depending on how far away they are), and more than that for other
; nodes.  A cost table is set up so that local nodes are 0 cost, nodes
; that will cost $0.11 or less during evening hours are listed as $0.11 and
; all other nodes are listed as $0.20.
;
; This gives the following table:
;
;   DAY       TIME      LD price
;  ----- ------------- ----------
;   Sun   00:00-17:00     0.11
;   Sun   17:00-22:00   variable
;   Sun   22:00-00:00     0.11
;  ----- ------------- ----------
;   Mon*  00:00-08:00     0.11
;   Mon   08:00-17:00   expensive
;   Mon   17:00-22:00   variable
;   Mon   22:00-00:00     0.11
;  ----- ------------- ----------
;   Sat   00:00-00:00     0.11
;
; * Rates for Monday are the same for Monday-Friday
;
; The system is set up to poll long distance when it is cheap, and to send
; local/free mail during the day.  At night, the local nodes must call in to
; get their mail.  A modification that shows how to make TIMS call those
; local nodes at night if they are 9600 baud and also send free crash mail
; mail during times when it would normally not dial to free nodes is included.
; One thing to note is the use of the TYPE=CM construct.  If the nodelist is
; accurate, this will keep you from trying to send crash mail to someone that
; can't take it!
;
; Minimal syntax is used in these examples, but you can make them as
; readable as you want.  TIMS should ignore irrelevant items on a line, so
; you can add English words to the lines to make them more readable.  You
; can also spell out the days of the week, etc.  For example:
;
;  RESTRICT TIME 00:00 01:59
;
; could also be written as:
;
;  RESTRICT this event to times between 00:00 and 01:59 every day
;
;
;****************************************************************************
;
; First off, put in Zone Mail Hour for Mountain Standard Time
; This is a special case, so it is listed first.  It needs to change
; if you change the time on your system when Daylight Savings Time occurs.
;
RESTRICT TIME 02:00 03:00
SEND ALL			;send all mail to all nodes
DELAY 90			;delay at least 90 seconds between calls
ENDRESTRICT

;
; Now put in the stuff that happens every single day
;
;****************************************************************************
;
; Starting from Midnight to ZMH
;
RESTRICT TIME 00:00 02:00
SEND ALL COST>0 TYPE=CM		;send all long distance if they are CM
SEND ALL COST=0 SPEED>=9600 TYPE=CM	;this would send to local 9600's too
SEND CRASH COST=0 TYPE=CM	;send free crash mail if necessary
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Next, ZMH-8am
;
RESTRICT TIME 03:00 08:00
SEND ALL COST>0 TYPE=CM		;send all long distance if they are CM
SEND ALL COST=0 SPEED>=9600 TYPE=CM	;this would send to local 9600's too
SEND CRASH COST=0 TYPE=CM	;send free crash mail if necessary
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; From 8am-10pm is different on different days, so now do 10pm-Midnight
;
RESTRICT TIME 22:00 24:00
SEND ALL COST>0 TYPE=CM		;send all long distance if they are CM
SEND ALL COST=0 SPEED>=9600 TYPE=CM	;this would send to local 9600's too
SEND CRASH COST=0 TYPE=CM	;send free crash mail if necessary
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do each day of the week for pieces that are separate
;
; Start with Sunday from 8am-5pm
;
RESTRICT TIME SUN 08:00 17:00
SEND ALL TYPE=CM		;send to everyone including locals
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Now Sunday from 5pm-10pm
;
RESTRICT TIME SUN 17:00 22:00
SEND ALL COST<=11 TYPE=CM	;send local and cheap long distance
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do Monday from 8am-5pm
;
RESTRICT TIME MON 08:00 17:00
SEND ALL COST=0 TYPE=CM		;send to local nodes only
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Now Monday from 5pm-10pm
;
RESTRICT TIME MON 17:00 22:00
SEND ALL COST<=11 TYPE=CM	;send local and cheap long distance
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do Tuesday from 8am-5pm
;
RESTRICT TIME TUE 08:00 17:00
SEND ALL COST=0 TYPE=CM		;send to local nodes only
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Now Tuesday from 5pm-10pm
;
RESTRICT TIME TUE 17:00 22:00
SEND ALL COST<=11 TYPE=CM	;send local and cheap long distance
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do Wednesday from 8am-5pm
;
RESTRICT TIME WED 08:00 17:00
SEND ALL COST=0 TYPE=CM		;send to local nodes only
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Now Wednesday from 5pm-10pm
;
RESTRICT TIME WED 17:00 22:00
SEND ALL COST<=11 TYPE=CM	;send local and cheap long distance
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do Thursday from 8am-5pm
;
RESTRICT TIME THU 08:00 17:00
SEND ALL COST=0 TYPE=CM		;send to local nodes only
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Now Thursday from 5pm-10pm
;
RESTRICT TIME THU 17:00 22:00
SEND ALL COST<=11 TYPE=CM	;send local and cheap long distance
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do Friday from 8am-5pm
;
RESTRICT TIME FRI 08:00 17:00
SEND ALL COST=0 TYPE=CM		;send to local nodes only
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; Now Friday from 5pm-10pm
;
RESTRICT TIME FRI 17:00 22:00
SEND ALL COST<=11 TYPE=CM	;send local and cheap long distance
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
;****************************************************************************
;
; Now do Saturday (cheap all day)
;
RESTRICT TIME SAT 08:00 22:00
SEND ALL TYPE=CM		;send to everyone including locals
DELAY 180			;delay 180 seconds between calls
ENDRESTRICT

;
; End of sample configuration file
;
;****************************************************************************
